//
//  Components.swift
//
//  Copyright © 2020 Apple Inc. All rights reserved.
//


import Foundation
import SpriteKit
import SPCCore
import SPCAudio

protocol AudioPlaying: class {
    /// Adds a sound to the graphic.
    ///
    /// - Parameter sound: The sound to add.
    /// - Parameter positional: Whether the sound changes based on the position of the graphic. The default is `true`.
    /// - Parameter looping: Whether the sound should loop. The default is `true`.
    /// - Parameter volume: The volume at which the sound is played (ranging from `0` to `100`). The default is `100`: full volume.
    ///
    /// - localizationKey: Graphic.addAudio(_:positional:looping:volume:)
    func addAudio(_ sound: Sound, positional: Bool, looping: Bool, volume: Double)
    func removeAudio()
    func setIsAudioPositional(isAudioPositional: Bool)
    func playAudio()
    func stopAudio()
}

public protocol Collidable: class {
    func setInteractionCategory(interactionCategory: InteractionCategory)
    func setCollisionCategories(collisionCategories: InteractionCategory)
    func setContactCategories(contactCategories: InteractionCategory)
    func setOnCollisionHandler(_ handler: @escaping (Collision)->Void)
}

protocol ToneSensing: class {
    
}

protocol LightSensing: class {
    
}

protocol MotionSensing: class {
    
}

protocol ImageProtocol: class {
    func setImage(image: Image)
    func setTiledImage(image: Image?, columns: Int?, rows: Int?, isDynamic: Bool?)
}

public protocol TextProtocol: class {
    var text: String { get set }
    var textColor: Color { get set}
    var fontName: String { get set}
    var fontSize: Int { get set }
}

protocol ShapeProtocol: class {
    func setShape(_ shape: BasicShape?)
}

public protocol Physicable: class {
    func setAffectedByGravity(gravity: Bool)
    func setIsDynamic(dynamic: Bool)
    func setAllowsRotation(rotation: Bool)
    func setVelocity(velocity: CGVector)
    func setRotationalVelocity(rotationalVelocity: Double)
    func setBounciness(bounciness: Double)
    func setFriction(friction: Double)
    func setDensity(density: Double)
    func setDrag(drag: Double)
    func setRotationalDrag(drag: Double)
    func applyImpulse(vector: CGVector)
    func applyForce(vector: CGVector, duration: Double)
}

protocol Scaleable: class {
    func setXScale(scale: Double)
    func setYScale(scale: Double)
}

public protocol Emittable: class {
    func addParticleEmitter(name: String, duration: Double, color: Color)
}

public protocol Actionable: class {
    func runAction(_ action: SKAction, name: String?, completion: (()->Void)?)
    func removeAction(name: String)
    func removeAllActions()
}

protocol Joinable: class {}

protocol TouchInteractable: class {
    func setAllowsTouchInteraction(_ allowsTouchInteraction: Bool)
    func setHandler(for type: InteractionType, handler: @escaping () -> Void)
}
